// ПРИМЕР ВЫВОДА РУССКОГО ТЕКСТА В РАЗНЫХ КОДИРОВКАХ:                  //
                                                                       //
// Arduino IDE в разное время использовала разную кодировку, значит    //
// в некоторых версиях кириллица на экран может выводиться некорректно //
// для исправления этой проблемы нужно указать кодировку setCoding().  //
                                                                       //
// OLED экран 128×64 / 0,96" (Trema-модуль):                           // https://iarduino.ru/shop/displays/ekran-0-96-128x64-oled-i2c-belyy.html
// Информация о подключении модулей к шине I2C:                        // https://wiki.iarduino.ru/page/i2c_connection/
// Информация о модуле и описание библиотеки:                          // https://wiki.iarduino.ru/page/OLED_trema/
// Библиотека   iarduino_OLED_txt (текстовая  ) экономит ОЗУ:          // https://iarduino.ru/file/341.html
// Библиотека   iarduino_OLED     (графическая):                       // https://iarduino.ru/file/340.html
                                                                       //
#include <Wire.h>                                                      // Подключаем библиотеку для работы с аппаратной шиной I2C, до подключения библиотеки iarduino_OLED_txt.
#include <iarduino_OLED_txt.h>                                         // Подключаем библиотеку iarduino_OLED_txt.
iarduino_OLED_txt myOLED(0x3C);                                        // Объявляем объект myOLED, указывая адрес дисплея на шине I2C: 0x3C или 0x3D.

int R; //Переменная Сопротивление резистора
int SSR_PIN=2; //Пин твердотельного реле
int POT_PIN=13; //Пин GND потенциометра

int FS_S_PIN=3; //Пин Сигнал датчика потока
int FS_V_PIN=4; //Пин Питания датчика потока
int FS_G_PIN=5; //Пин GND датчика потока

float varQ; // Объявляем переменную для хранения рассчитанной скорости потока воды (л/с).
float varV; // Объявляем переменную для хранения рассчитанного объема воды (л).

void setup(){                                                          //
     myOLED.begin(&Wire); // &Wire1, &Wire2 ...                        // Инициируем работу с дисплеем, указав ссылку на объект для работы с шиной I2C на которой находится дисплей (по умолчанию &Wire).
     pinMode(POT_PIN, OUTPUT);                                         // Конфигурация вывода земли потенциометра
     pinMode(SSR_PIN, OUTPUT);                                         // Конфигурация вывода твердотельного реле
     pinMode(FS_S_PIN, INPUT);                                         // Конфигурация сигнального вывода датчика
     pinMode(FS_V_PIN, OUTPUT);                                        // Конфигурация вывода питания датчика
     pinMode(FS_G_PIN, OUTPUT);                                        // Конфигурация вывода земли датчика
     digitalWrite(POT_PIN, LOW);                                       // Притягивание к "земле вывода" потенциометра
     digitalWrite(FS_V_PIN, HIGH);                                     // Притягивание к питанию вывода питания датчика
     digitalWrite(FS_G_PIN, LOW);                                      // Притягивание к "земле" вывода датчика
     varQ=0; varV=0;                                                   // Зануление переменных скорости и объема воды

void loop(){                                                           // Основной цикл программы
     varQ           = 0;                                         // Сбрасываем скорость потока воды.
     uint32_t varL  = pulseIn(FS_S_PIN, HIGH, 200000);           // Считываем длительность импульса, но не дольше 0,2 сек.
     if( varL ){                                                 // Если длительность импульса считана, то ...
        float varT = 2.0 * (float)varL / 1000000;                // Определяем период следования импульсов в сек.
        float varF = 1/varT;                                     // Определяем частоту следования импульсов в Гц.
        varQ       = (varF / 450.0f)*20;                         // Определяем скорость потока воды л/с (увеличено в 20 раз).
        varV      += varQ * varT;                                // Определяем объем воды л.
     }
     R=analogRead(A0);                                           // Считывание значения сопротивления с аналогового входа, куда подключен потенциометр
     R=map(R, 0, 1023, 0, 100);                                  // Переназначение сопротивления из текущего диапазона значений (0 .. 1023) в новый диапазон (0 .. 100)
     if (R>50) {digitalWrite(SSR_PIN, HIGH);}                    // Условие включения насоса: при сопротивлении больше 50% от максимального - включается твердотельное реле (и насос соответственно) 
     if (R<50) {digitalWrite(SSR_PIN, LOW);}                     // Условие выключения насоса: при сопротивлении меньше 50% от максимального - выключается твердотельное реле (и насос соответственно)
     myOLED.setCoding(TXT_UTF8);                                 // Блок работы с экраном: Меняем кодировку на UTF-8 (по умолчанию).
     myOLED.setFont(SmallFontRus);                               // Выбираем шрифт с поддержкой русского языка
     myOLED.print("Поток, л/ч:", OLED_C, 1);                     // Вывод на экран скорости потока воды через датчик
     myOLED.setFont(MediumFontRus);                              // Выбор шрифта
     myOLED.print(varQ, 40, 3);                                  // Переменная потока и координаты положения на экране
     myOLED.print(" ", OLED_N);
     myOLED.setFont(SmallFontRus);                               // Выбор шрифта
     myOLED.print("Объем:", 10, 6);                              // Вывод на экран объема потока воды через датчик
     myOLED.print(varV, 10, 7);                                  // Переменная объема и координаты положения на экране
     myOLED.print(" литров", OLED_N);
     myOLED.print("R:", 100, 6);                                 // Вывод на экран переменной положения потенциометра и координаты положения на экране
     myOLED.print(R, 100, 7);                                    // Переменная сопротивления потенциометра и координаты положения на экране
     myOLED.print("%", OLED_N);
}
/*   КОДЫ СИМВОЛОВ:                                                    //
 *   Латинские буквы A-Z и a-z                                         // Вводятся как есть, вне зависимости от кодировки.
 *   Цифры 0-9 и символы !"#$%&'()*+,-./:;<=>?@[]^_`{|}~               // Вводятся как есть, вне зависимости от кодировки.
 *   Буквы АБВГДЕЖЗИЙКЛМНОП                                            // Код: 128-143 в 10-тичной системе счисления, для кодировки CP-866.
 *   Буквы РСТУФХЦЧШЩЪЫЬЭЮЯ                                            // Код: 144-159 в 10-тичной системе счисления, для кодировки CP-866.
 *   Буквы абвгдежзийклмноп                                            // Код: 160-175 в 10-тичной системе счисления, для кодировки CP-866. 
 *   Буквы рстуфхцчшщъыьэюя                                            // Код: 224-239 в 10-тичной системе счисления, для кодировки CP-866.
 *   Буквы Ё,ё                                                         // Код: 240,241 в 10-тичной системе счисления, для кодировки CP-866.
 *                                                                     //
 *   Для вывода любого символа нужно указать его код в 8-ричной системе//
 *   счисления, которому должен предшествовать символ '\', или указать //
 *   код в 16-ричной системе, тогда ему предшествует два символа "\x". //
 *                                                                     //
 *   Пример вывода Русской буквы «А» в кодировке CP-866:               //
 *   - букве «А» соответствует код 128.                                // Для перевода чисел из 10-тичной в 8-ричную и 16-ричную систему можно воспользоваться стандартным калькулятором в windows.
 *   - 128 DEC = 200 OCT = 80 HEX.                                     // Выберите вид калькулятора - «Программист» и введите число, Вы увидите его представление в разных системах счисления: HEX(16), DEC(10), OCT(8) и BIN(2).
 *   - Значит буква «А» записывается как \200 или \x80                 // Далее в примере следует буква «р» \340, «д» \244, «у» \343, «и» \250, «н» \255, «о» \256.
 *                                                                     //
 *   Запись текста кодами символов кажется более громоздкой, но        //
 *   на самом деле, такая запись занимает в 2 раза меньше памяти       //
 *   чем хранение текста Кириллицей в кодировке UTF-8.                 //
 *                                                                     //
 *   ДОСТУПНЫЕ ШРИФТЫ:                                                 // Шрифты можно менять и добавлять в файле: src/DefaultFonts.h
 *   SmallFont                                                         // Маленький шрифт  6x8  ( 95 символов) только латиница
 *   SmallFontRus                                                      // Маленький шрифт  6x8  (176 символов) латиница и кириллица
 *   MediumFont                                                        // Средний   шрифт 12x16 ( 95 символов) только латиница
 *   MediumFontRus                                                     // Средний   шрифт 12x16 (176 символов) латиница и кириллица
 *   MediumNumbers                                                     // Средние   цифры 12x16 ( 13 символов) 0123456789./-
 *   BigNumbers                                                        // Большие   цифры 14x24 ( 13 символов) 0123456789./-
 *   MegaNumbers                                                       // Большие   цифры 24x40 ( 13 символов) 0123456789./-
 */
